//=============================================================================
// Quasi Quick Touch
// Version: 1.01
// Last Update: May 25, 2016
//=============================================================================
// ** Terms of Use
// https://github.com/quasixi/Quasi-MV-Master-Demo/blob/master/README.md
//=============================================================================
// Downloading from Github
//  - Click on Raw next to Blame and History
//  - Once new page loads, right click and save as
//=============================================================================
// How to install:
//  - Save this file as "QuasiQuickTouch.js" in your js/plugins/ folder
//=============================================================================

var Imported = Imported || {};
Imported.QuasiQuickTouch = 1.01;

//=============================================================================
 /*:
 * @plugindesc Select windows activate on single click
 * Version 1.01
 * <QuasiQuickTouch>
 * @author Quasi       Site: http://quasixi.com
 */
//=============================================================================

//-----------------------------------------------------------------------------
// Quasi Quick Touch

(function() {

  TouchInput._onMouseMove = function(event) {
    var x = Graphics.pageToCanvasX(event.pageX);
    var y = Graphics.pageToCanvasY(event.pageY);
    this._onMove(x, y);
	
	if ($gameVariables && x && y) {
		$gameVariables.setValue(207, x)
		$gameVariables.setValue(208, y)
	}
  };

  //-----------------------------------------------------------------------------
  // Window_Selectable
  //
  // The window class with cursor movement and scroll functions.

  var Alias_Window_Selectable_initialize = Window_Selectable.prototype.initialize;
  Window_Selectable.prototype.initialize = function(x, y, width, height) {
    Alias_Window_Selectable_initialize.call(this, x, y, width, height);
    this._oldTouchX = TouchInput.x;
    this._oldTouchY = TouchInput.y;
  };





  Window_Selectable.prototype.processTouch = function() {
    if (this.isOpenAndActive()) {
      if (this.isTouchedInsideFrame()) {
        var x = this.canvasToLocalX(TouchInput.x);
        var y = this.canvasToLocalY(TouchInput.y);
        var hitIndex = this.hitTest(x, y);
        if (hitIndex >= 0 && this.isCursorMovable() && this.mouseMoved()) {
          this.select(hitIndex);
        }
        if (TouchInput.isTriggered()) {
          if (hitIndex >= 0) {
            if (hitIndex === this.index() && this.isTouchOkEnabled()) {
//							this._touching = true;
//							this.onTouch(true);						
              this.processOk();
            }
          }
        }
      }
      if (TouchInput.isCancelled()) {
        if (this.isCancelEnabled()) {
          this.processCancel();
        }
      }
    }
  };
  

nk_Scene_Save_update = Scene_Save.prototype.update
Scene_Save.prototype.update = function() {
	nk_Scene_Save_update.call(this)
	
	if (ConfigManager.touchbuttons && this._listWindow && this.sprite) {
		var topRow = this._listWindow.topRow();
		var maxTopRow = this._listWindow.maxTopRow();
		if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
			this.sprite.visible = true
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
		else if (topRow > 0) {
			this.sprite.visible = false
			this.spriteU.visible = true
			this.spriteD.visible = false
		}
		else if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = true
		}
	}

	
	if ((TouchInput.isReleased() && $gameSwitches.value(158)) || $gameSwitches.value(157)) { //runs after leaving naming window
		this._listWindow.select($gameVariables.value(32));
		this._listWindow.processOk(); //auto save after get out of naming
		$gameSwitches.setValue(157, false)
		$gameSwitches.setValue(158, false)
	}
	
	if (Utils.isMobileDevice()) {
		var x = 1096
		var y = 552
		var w = Graphics.width - x
		var h = Graphics.height - y
	}
	else {
		var x = 1159
		var y = 684
		var w = 87
		var h = 36
	}



	if (ConfigManager.touchbuttons) {
		if ((TouchInput._y >= y &&	TouchInput._y <= y+h) &&
		(TouchInput._x >= x && TouchInput._x <= x+w) &&
		TouchInput._pressedTime==1) {
			SoundManager.playCancel();
			TouchInput.clear();
			this.popScene();
		}
		
		if (Utils.isMobileDevice()) {
			x = 753
			y = 0
			w = 63
			h = 71
		}
		else {
			x = 764
			y = 31
			w = 41
			h = 37
		}


		if ((TouchInput._y >= y &&	TouchInput._y <= y+h) &&
		(TouchInput._x >= x && TouchInput._x <= x+w) &&
		(TouchInput._pressedTime==1 || (TouchInput._pressedTime >= Input.keyRepeatWait &&
		TouchInput._pressedTime % Input.keyRepeatInterval == 0))) {
			if (this.sprite.visible || this.spriteU.visible) {
				SoundManager.playCursor();
			}
			this._listWindow.cursorPageup();
		}

		if (Utils.isMobileDevice()) {
			y = 417
		}
		else {
			y = 434
		}


		if ((TouchInput._y >= y &&	TouchInput._y <= y+h) &&
		(TouchInput._x >= x && TouchInput._x <= x+w) &&
		(TouchInput._pressedTime==1 || (TouchInput._pressedTime >= Input.keyRepeatWait &&
		TouchInput._pressedTime % Input.keyRepeatInterval == 0))) {
			if (this.sprite.visible || this.spriteD.visible) {
				SoundManager.playCursor();
			}
			this._listWindow.cursorPagedown();
		}
	}
	
}
	
  Window_SavefileList.prototype.processTouch = function() {
    if (this.isOpenAndActive()) {
      if (this.isTouchedInsideFrame()) {
        var x = this.canvasToLocalX(TouchInput.x);
        var y = this.canvasToLocalY(TouchInput.y);
        var hitIndex = this.hitTest(x, y);
        if (hitIndex >= 0 && this.isCursorMovable() && this.mouseMoved()) {
          this.select(hitIndex);
        }
		if ($gameVariables.value(33) == 1) { //save
			if (TouchInput.isPressed()) {
				if (hitIndex >= 0) {
					if (hitIndex === this.index() && this.isTouchOkEnabled()) {
						if (this.index() == 0) {
							SoundManager.playBuzzer()
							TouchInput.clear();
						}
						else {
							$gameVariables.setValue(32, this.index())
							$gameSwitches.setValue(158, true)
							if (TouchInput._pressedTime >= 50) { //hold to input custom name
								TouchInput.clear();
								
								if (ConfigManager.touchbuttons) {
									$gameScreen.showPicture(456, "zBtnBack", 0, 0, 0, 100, 100, 255, 0);
								}
								else {
									$gameScreen.erasePicture(456);
								}
								
								SoundManager.playOk()
								SceneManager.push(Scene_Name);
								SceneManager.prepareNextScene(20, 16);
							}
						}
					}
				}
			}
		}
		else {
			if (TouchInput.isTriggered()) {
				if (hitIndex >= 0) {
					if (hitIndex === this.index() && this.isTouchOkEnabled()) {
						this.processOk();
					}
				}
			}
		}
      }
      if (TouchInput.isCancelled()) {
        if (this.isCancelEnabled()) {
          this.processCancel();
        }
      }
    }
  };
  

  Window_Selectable.prototype.mouseMoved = function() {
    if (this._oldTouchX !== TouchInput.x || this._oldTouchY !== TouchInput.y) {
      this._oldTouchX = TouchInput.x;
      this._oldTouchY = TouchInput.y;
      return true;
    }
    return false;
  };
}());




var Window_Selectable_processTouch_wait = Window_Selectable.prototype.processTouch
Window_ItemList.prototype.processTouch = function() {
	if (!Utils.isMobileDevice()) {
		Window_Selectable_processTouch_wait.call(this)
	}
	else {
		if (this.isOpenAndActive()) {
			if (TouchInput.isTriggered() && this.isTouchedInsideFrame()) {
				this._touching = true;
				this.onTouch(true);
			} else if (TouchInput.isCancelled()) {
				if (this.isCancelEnabled()) {
					this.processCancel();
				}
			}
			if (this._touching) {
				if (TouchInput.isPressed()) {
					this.onTouch(false);
				} else {
					this._touching = false;
				}
			}
		} else {
			this._touching = false;
		}
	}
};

Window_SkillList.prototype.processTouch = function() {
	Window_ItemList.prototype.processTouch.call(this)
}

Window_ShopBuy.prototype.processTouch = function() {
	Window_ItemList.prototype.processTouch.call(this)
}

